/* v1.1
 *
 * rxl_lightsecond.c:  Range Convertor for Light Seconds.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 */

#include <stdlib.h>
#include "../spaceconf.h"
#include "../pseint.h"
#include "../dbint.h"
#include "../space.h"
#include "rxl.h"

extern RXL_INTERFACE rxl_lightsecond;
extern int rxl_lightsecond_InitModule();
extern int rxl_lightsecond_FreeModule();
extern int rxl_lightsecond_FormatSz(char *, int, range_t, int);

RXL_INTERFACE rxl_lightsecond = {
    "LightSeconds",
    0,
    rxl_lightsecond_InitModule,
    rxl_lightsecond_FreeModule,
    rxl_lightsecond_FormatSz
};

/*
 * InitModule: Allocate and setup any translation tables required
 */
int rxl_lightsecond_InitModule()
{
    return 1;
}

/*
 * FreeModule: Free any translation tables and so forth
 */
int rxl_lightsecond_FreeModule()
{
    return 1;
}

/*
 * FormatSz: Fill the provided buffer with the translated range, and return
 *           the translated string length.
 */
int rxl_lightsecond_FormatSz(char *buff, int maxlen, range_t range, int flags)
{
    if (TRUNCSTR(snprintf(buff, maxlen, RANGEF, range))) {

	buff[maxlen - 1] = '\0';
	
    }

    return strlen(buff);
}
