/* v1.1
 *
 * pseint.h:  PSE-MUD platform-independent macros and definitions.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */ 

#ifndef NULL
#define NULL 0
#endif

#ifndef PLATFORM_H
typedef int dbref;
#endif

/* This is required to compile with C calling conventions if the compiler
 * used for platform.c is a C++ compiler - eg, when compiling TinyMUX 2.0
 */
#if defined(__GNUG__) || defined(__cplusplus)
#define CLINK extern "C"
#else
#define CLINK extern
#endif

/* Memory allocation routines */
CLINK void *pse_malloc(int);
CLINK void *pse_calloc(int, int);
CLINK char *pse_strdup(const char *s);
CLINK void pse_do_free(void *);
#define pse_free(x)      pse_do_free(x); x=NULL

/* Evaluation Reset Routine */
CLINK void ResetEval(void);

/* Output routines */
CLINK void pse_strip_ansi(char *); /* In-situ ansi stripping */
CLINK void Notify(dbref, const char *);
CLINK void NotifyExcept(dbref,dbref,const char *);
CLINK void NotifyLocation(dbref, const char *);
CLINK void *AllocBuffer(const char *);
CLINK void FreeBuffer(void *);
CLINK int ValidObject(dbref);

CLINK void WriteMudFunctionBuffer(void *, const char *);
CLINK void FWriteMudFunctionBuffer(void *, const char *, ...);

#define WriteFunctionBuffer(x) WriteMudFunctionBuffer(mud, x)
#define FWriteFunctionBuffer(x,y) FWriteMudFunctionBuffer(mud, x, y)
#define FWriteFunctionBuffer2(x,y,z) FWriteMudFunctionBuffer(mud, x, y, z)

CLINK void spacecall(void *mud, dbref Player, dbref Cause, const char *Args[],
		      int NumArgs);

typedef void (*F_COMMAND)(void *, dbref, const char **);
typedef void (*F_FUNCTION)(void *, void *, dbref, const char **);

#define CALL_COMMAND(fun, object, cause, args) \
	(*((F_COMMAND)fun))(object, cause, args)		

#define CALL_FUNCTION(fun, object, cause, args) \
	(*((F_FUNCTION)fun))(object, mud, cause, args)

CLINK void getObjectName(char *, dbref, int);
CLINK void getEvalAttrBuf(dbref, const char *, char **, unsigned int, char *);
CLINK int getAttrNumber(const char *);
CLINK void getAttrByNumberLen(char *, dbref, int, int);
CLINK void getAttrByNameLen(char *, dbref, const char *, int);
CLINK void setAttrByNumber(dbref, int, const char *);
CLINK void setAttrByName(dbref, const char *, const char *);
CLINK dbref parseDbref(const char *);
CLINK dbref getLocation(dbref);
CLINK dbref getDebugCharacter(void);
CLINK dbref getDbrefByNumber(dbref, int);
CLINK dbref getDbrefByName(dbref, const char *);
CLINK int isSpace(dbref);

#define PSE_NOTHING       -100
#define PSE_DATA_DBREF    -101
#define PSE_USER_DBREF    -102

CLINK int debug_char; /* used for directing log messages to objects */

