/* v1.1
 *
 * platform.h:  MUD platform-specific macros and definitions.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */ 

#ifndef PLATFORM_H
#define PLATFORM_H

#define SPACE

#ifndef NULL
#define NULL 0
#endif

#ifdef MUSH
#define lint      /* Cure the annoying warning messages */
#endif

/*
 * Include headers from Mux / Mush / Penn as appropriate. The server choice
 * is made in spaceconf.h
 */

#if defined(MUX2)

#include <copyright.h>
#include <autoconf.h>
#include <config.h>
#include <externs.h>
#include <mudconf.h>
#include <db.h>
#include <interface.h>
#include <attrs.h>
#include <alloc.h>
#include <htab.h>
#include <match.h>
#include <command.h>
#include <functions.h>
#include <flags.h>

#else
#if defined(MUX) || defined(MUSH) || defined(MUSH3)

#include <copyright.h>
#include <autoconf.h>
#include <mudconf.h>
#include <config.h>
#include <db.h>
#include <interface.h>
#include <externs.h>
#include <match.h>
#include <command.h>
#include <alloc.h>
#include <attrs.h>
#include <functions.h>
#include <flags.h>

#else
#if defined(PENN)

/*
 * Probably really need a few more than this here...seems to work though.
 */
#include <externs.h>
#include <attrib.h>
#include <parse.h>
#include <dbdefs.h>

/*
 * PENN does not declare the function invocation limits in a header.
 */

extern int global_fun_invocations;
extern int global_fun_recursions;

#else
#error No platform defined.
#endif
#endif
#endif

/*
 * This is the prototype for MU* functions.
 */

#if defined(MUX2)
#define MUDFUNCTION(x) \
extern void x(char *buff, char **bufc, dbref player, dbref cause, \
       char *fargs[], int nfargs, char *cargs[], int ncargs)

typedef struct
{
    char *buff;
    char **bufc;
} MUDPARAM;
#else
#if defined(MUX)
#define MUDFUNCTION(x)     \
void x(char *buff, char **bufc, dbref player, dbref cause, \
       const char *fargs[], int nfargs, const char *cargs[], int ncargs)

typedef struct
{
    char *buff;
    char **bufc;
} MUDPARAM;

#else
#if defined(MUSH)
#define MUDFUNCTION(x)     \
void x(buff, player, cause, fargs, nfargs, cargs, ncargs) \
        char *buff; \
        dbref player, cause; \
        const char *fargs[], *cargs[]; \
        int nfargs, ncargs;

typedef struct
{
    char *buff;
} MUDPARAM;
#else
#if defined(MUSH3)
#define MUDFUNCTION(x)     \
void x(buff, bufc, player, cause, fargs, nfargs, cargs, ncargs) \
        char *buff; \
	char **bufc; \
        dbref player, cause; \
        const char *fargs[], *cargs[]; \
        int nfargs, ncargs;

typedef struct
{
    char *buff;
    char **bufc;
} MUDPARAM;

#else
#if defined(PENN)

#ifndef IsGarbage
#define IsGarbage(x) Destroyed(x)
#endif

#define MUDFUNCTION(x)     \
void x(buff, bufc, nargs, args, executor, caller, enactor, called_as, \
        pe_info) \
        char *buff; \
        char **bufc; \
        int nargs; \
        const char *args[]; \
        dbref executor; \
        dbref caller; \
        dbref enactor; \
        const char *called_as; \
        PE_Info *pe_info;

typedef struct
{
    char *buff;
    char **bufc;
    PE_Info *pe_info;
} MUDPARAM;

#else
#error No platform defined.
#endif
#endif
#endif
#endif
#endif

#endif
