/* v1.1
 *
 * btree.h:  Hash table declarations
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#ifndef _BTREE_H
#define _BTREE_H

typedef struct btree_node BNODE;

struct btree_node {
     BNODE *left_child;
     BNODE *right_child;
     const char *key;
     int *data;
     int free;
};

extern void *btreeSearch(const char *, BNODE *);
extern void *btreeSearchLen(const char *, BNODE *, int);
extern void btreeInsert(const char *, void *, BNODE **);
extern void btreeFree(BNODE *);

#endif /* _HASHTAB_H */




