/* v0.9
 *
 * scm-hull.c:  Shield Class Module for Hull.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 */

#include <stdlib.h>
#include "../spaceconf.h"
#include "../pseint.h"
#include "../dbint.h"
#include "../space.h"
#include "scm.h"

extern SCM_INTERFACE scm_hull;
extern int scm_hull_InitModule();
extern int scm_hull_FreeModule();
extern int scm_hull_LoadLayer(dbref, SCLAYER*, const char*);

/* Define the entries needed on the shield class definition object to
 * support this shield class. */

#define CF_HULL_FACTOR			0
#define CF_HULL					1

static VArrayIndex *vidx = NULL;
static VAIDXENTRY vars[] = {

    {"CF_HULL_FACTOR", CF_HULL, VA_TYPE_FLOAT|VA_REQUIRED, 0, NULL},
    {"CF_HULL",        CF_HULL, VA_TYPE_INT|VA_REQUIRED,   0, NULL},
    {"", 0, 0, 0, NULL}
};

/* Define the entries used by the shield class handlers to initialize,
 * free, and use this shield class. */

SCM_INTERFACE scm_hull = {
    "Hull",
    0,
    scm_hull_InitModule,
    scm_hull_FreeModule,
    scm_hull_LoadLayer
};

int scm_hull_InitModule()
{
    /* Create a VArray index from the above table */
    vidx = vaCreateIndexFromTable(vars);
    if (vidx == NULL)
	return 0;
    
    return 1;
}

int scm_hull_FreeModule()
{
    /* Free the VArray index if we created it */
    if (vidx) {
	vaFreeIndex(vidx);
	vidx = NULL;
    }
    
    /* Do any other cleanup here */
    
    return 1;
}

int scm_hull_LoadLayer(dbref data, SCLAYER *layer, const char *szData)
{
    return 1;
}
