/* v0.9
 *
 * pseint.h:  PSE-MUD platform-independent macros and definitions.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */ 

#ifndef NULL
#define NULL 0
#endif

#ifndef PLATFORM_H
typedef int dbref;
#endif

/* Memory allocation routines */
extern void *pse_malloc(int);
extern void *pse_calloc(int, int);
extern void *pse_realloc(void *, int);
#define pse_free(x) free(x)

/* Output routines */
extern char *strip_ansi(const char *);
extern void Notify(dbref, const char *);
extern void NotifyExcept(dbref,dbref,const char *);
extern void NotifyLocation(dbref, const char *);
extern void *AllocBuffer(const char *);
extern void FreeBuffer(void *);
extern int ValidObject(dbref);

extern void WriteMudFunctionBuffer(void *, const char *);
extern void FWriteMudFunctionBuffer(void *, const char *, ...);

#define WriteFunctionBuffer(x) WriteMudFunctionBuffer(mud, x)
#define FWriteFunctionBuffer(x,y) FWriteMudFunctionBuffer(mud, x, y)

extern void spacecall(void *mud, dbref Player, dbref Cause, char *Args[],
		      int NumArgs);

typedef void (*F_COMMAND)(void *, dbref, char **);
typedef void (*F_FUNCTION)(void *, void *, dbref, char **);

#define CALL_COMMAND(fun, object, cause, args) \
	(*((F_COMMAND)fun))(object, cause, args)		

#define CALL_FUNCTION(fun, object, cause, args) \
	(*((F_FUNCTION)fun))(object, mud, cause, args)

extern int getAttrNumber(const char *);
extern const char *getAttrByNumber(dbref, int);
extern const char *getAttrByName(dbref, const char *);
extern void getAttrByNumberLen(char *, dbref, int, int);
extern void getAttrByNameLen(char *, dbref, const char *, int);
extern const char *getEvalAttr(dbref, const char *, char **, unsigned int);
extern void setAttrByNumber(dbref, int, const char *);
extern void setAttrByName(dbref, const char *, const char *);
extern const char *getObjectName(dbref);
extern dbref parseDbref(const char *);
extern dbref getLocation(dbref);
extern dbref getDebugCharacter(void);
extern int isSpace(dbref);

#define PSE_NOTHING       -100
#define PSE_DATA_DBREF    -101
#define PSE_USER_DBREF    -102

extern int debug_char; /* used for directing log messages to objects */
