/* v0.9
 *
 * flag.h:  Flag handler header.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

/* Available flag lists */
enum FLAGS
{
    FLIST_OBJECT = 0,
    FLIST_SHIP,
    FLIST_CONSOLE,
    FLIST_END           /* Used to terminate the list. Must be last. */
};

#define MAX_FLAG_LISTS     20
#define MAX_FLAGS_PER_LIST 32

/* The call-once inbuilt flag initialization code */
extern void flagInit(void);

/* General interface calls */
extern int loadBinaryFlags(unsigned int *, const char *);
extern const char *loadSymbolicFlags(unsigned int *, enum FLAGS, const char *);
extern const char *saveSymbolicFlags(unsigned int, enum FLAGS, int);
extern int setFlag(unsigned int*, int, enum FLAGS, const char *);
extern int setFlagWithLen(unsigned int*, int, enum FLAGS, const char*, int);
extern int isFlagSet(unsigned int, enum FLAGS, const char *);

/* Used by modules to register new flag lists, and to modify existing ones */
extern int flagRegisterFlagList(int);
extern int flagRegisterFlagEntry(int, int, const char *);
