/* v0.8
 * 
 * spaceconf.h:	Space engine hard-configurable options
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

/* 
 * Note:  Please let me know what should be made configurable!
 */

/*
 * 1.  Choose a Platform.
 *	Currently only MUX is supported, but subsequent versions of the engine 
 *	will be designed with portability in mind.
 *
 */

#define MUX	/* Tested on:  TinyMUX v1.4p5 */
/* #define MUSH	*/ /* Tested on:  TinyMUSH v2.2.3 */

/*
 * 2.  Configure size parameters.
 *
 */


/* Number of spaces.  Space 0 is always real space, and 1+ are sim spaces. */

#define NUM_SPACES		2

/* Maximum attribute length.  This defines the maximum length
 * of the attributes that are accessed by the space engine, both
 * before and after any functions are evaluated.  Note that if
 * this number is too small, the space engine may truncate 
 * attributes or (worse) crash.  If the number is too large, the
 * engine will consume extra memory needlessly.
 */
#define MAX_ATTRIBUTE_LEN 5000


/*
 * 3.  Configure feature set.
 *	Choose the features that your space system will incorporate.
 *	(Currently all features enabled.)
 *
 */

/* Log new contacts, and contacts lost? */

/* #define LOG_CONTACTS */ /* */
