/* v0.8
 *
 * space.h:  General space definitions.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#define FALSE 0
#define TRUE  1

#ifndef PI
#define PI 3.1415926535897
#endif

#define FRAND ((float)( rand() & 65535 ) / 65536.0)
#define Max(x,y)	(x > y ? x : y)
#define Min(x,y)	(x < y ? x : y)
#define Sign(x)		(x >= 0 ? 1 : -1)

/* Size of attribute buffer */
#define LARGE_BUF_SIZE  16000
#define SMALL_BUF_SIZE  400

#define MAX_TORPS     	6
#define MAX_GUNS		6
#define MAX_CHANNELS            6
#define MAX_TEAMS 		6
#define NUM_SYSTEMS		26

#define INFO_VERBOSE 		0
#define INFO_TERSE		1

#define SS_SCAN   		0
#define SS_REPORT 		1

/* shield indices */
#define FORE_SHIELD             0
#define AFT_SHIELD              1
#define PORT_SHIELD             2
#define STARBOARD_SHIELD        3

/* miscellaneous configurable paramaters */
#define DOCK_RANGE		5	/* how close to starbase must you be */
#define BATTERY_BLEED		0.97	/* % of btty lost per turn online */
#define SHLD_READY_BLEED	0.99	/* loss on ready shields */
#define SHLD_UP_BLEED		0.90	/* loss on raised shields */

/*
 * Sensor penalties for cloaked ships, and uncloaked ships at quarter penalty
 */

#define GUN_ONLINE_PENALTY   0.05
#define TORP_CHARGING_PENALTY 0.20
#define TORP_ARMED_PENALTY    0.40 

/* ship text field sizes */
#define NAME_LEN		32
#define CLASS_LEN		32
#define TYPE_LEN		32
#define OWNER_LEN		32

/* cartesian coordinate struct */
typedef struct xyz_coord {
	int x;
	int y;
	int z;
} XYZ;

/* spherical coordinate struct */
typedef struct sph_coord {
	float bearing;
	float elevation;
	int range;
} SPH;

/* Global constants */
extern char *space_names[];
extern char *system_names[];

/* Global linked list pointers */
extern int space_lock[];
